/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.sonar.client.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.mule.tools.connectivity.sonar.client.database.model.GlobalRoles;
import org.mule.tools.connectivity.sonar.client.database.model.Project;
import org.mule.tools.connectivity.sonar.client.database.model.ProjectRoles;
import org.mule.tools.connectivity.sonar.client.database.model.User;

public class SonarDBClient {
    public Connection connection;

    public SonarDBClient(String url, String dbName, String user, String password) throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:mysql://" + url + "/" + dbName + "?user=" + user + "&password=" + password + "");
    }

    public boolean ping() throws SQLException {
        return this.connection.isValid(500);
    }

    public List<User> getUsers() throws SQLException {
        ResultSet rs = this.executeQuery("SELECT * FROM users;");
        return this.getUsers(rs);
    }

    public List<User> getUsers(User user) throws SQLException {
        ResultSet rs = this.executeQuery("SELECT * FROM users where id like '%" + user.getId() + "%' and email like '%" + user.getEmail() + "%';");
        return this.getUsers(rs);
    }

    public List<User> getUser(String email) throws SQLException {
        ResultSet rs = this.executeQuery("SELECT * FROM users where email like '%" + email + "%';");
        return this.getUsers(rs);
    }

    public List<Project> getProjects() throws SQLException {
        ResultSet rs = this.executeQuery("SELECT * FROM resource_index where qualifier = 'TRK' and position = '0';");
        return this.getProjects(rs);
    }

    public List<Project> getProjects(Project project) throws SQLException {
        ResultSet rs = this.executeQuery("SELECT * FROM resource_index where kee like '%" + project.getName().toLowerCase() + "%' and resource_id like '%" + project.getResourceId() + "%' and qualifier = 'TRK' and position = '0';");
        return this.getProjects(rs);
    }

    public List<Project> getProjectsByGroupAndArtifact(String groupAndArtifact) throws SQLException {
        ResultSet rs = this.executeQuery("SELECT ri.* FROM resource_index ri INNER JOIN projects p ON ri.resource_id = p.id WHERE p.kee = '" + groupAndArtifact + "' AND position = 0;");
        return this.getProjects(rs);
    }

    private List<Project> getProjects(ResultSet rs) throws SQLException {
        ArrayList<Project> projectsList = new ArrayList<Project>();
        while (rs.next()) {
            Project project = new Project();
            project.setName(rs.getString("kee"));
            project.setResourceId(rs.getString("resource_id"));
            project.setNameSize(rs.getInt("name_size"));
            projectsList.add(project);
        }
        return projectsList;
    }

    private List<User> getUsers(ResultSet rs) throws SQLException {
        ArrayList<User> userList = new ArrayList<User>();
        while (rs.next()) {
            User user = new User();
            user.setName(rs.getString("name"));
            user.setEmail(rs.getString("email"));
            user.setId(rs.getString("id"));
            user.setLogin(rs.getString("login"));
            userList.add(user);
        }
        return userList;
    }

    public Integer createUser(String name, String lastname, String email) throws SQLException {
        String query = "INSERT INTO `users` (`login`, `name`, `email`, `created_at`, `updated_at`,`active`) VALUES ('" + this.getSonarUserName(name, lastname) + "', '" + this.getSonarUserName(name, lastname) + "', '" + email + "', '2015-02-05 06:31:04', '2015-02-05 06:31:04','1');";
        return this.executeUpdate(query);
    }

    public Integer addGlobalPermission(User user, GlobalRoles role) throws SQLException {
        return this.executeUpdate("INSERT INTO `user_roles` (`user_id`, `role`) VALUES ('" + user.getId() + "','" + role.sqlname + "');");
    }

    public Integer addProjectPermission(User user, Project project, ProjectRoles role) throws SQLException {
        if (this.userHasProjectPermission(user, project, role)) {
            return null;
        }
        return this.executeUpdate("INSERT INTO `user_roles` (`user_id`,`role`,`resource_id`) VALUES ('" + user.getId() + "','" + role.sqlname + "','" + project.getResourceId() + "');");
    }

    public ResultSet getProjectPermission(User user, Project project, ProjectRoles role) throws SQLException {
        return this.executeQuery("SELECT * FROM `cb-ci-muleconn`.user_roles where user_id = " + user.getId() + " and resource_id = " + project.getResourceId() + " and role ='" + role.sqlname + "';");
    }

    public boolean userHasProjectPermission(User user, Project project, ProjectRoles role) throws SQLException {
        return this.getProjectPermission(user, project, role).next();
    }

    public ResultSet executeQuery(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(query);
    }

    public Integer executeUpdate(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeUpdate(query);
    }

    public String getSonarUserName(String name, String lastname) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase() + " " + lastname.substring(0, 1).toUpperCase() + lastname.substring(1).toLowerCase();
    }
}

