/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.util;

import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;

public class StepBuilder {
    public static final String BATCH_MODE = " -B";
    public static final String MAVEN_CLEAN = " clean ";
    public static final String JACOCO_PREPARE_PHASE = " org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent";
    public static final String SONAR_PHASE = " org.codehaus.mojo:sonar-maven-plugin:2.6:sonar";
    public static String MAVEN_REPO_SETTINGS = " -Dmavenlocalrepo=/home/jenkins/.m2 -Dm2home=/opt/maven/latest";
    public static String MAVEN_NAME = "(Default)";

    public static void setMavenRepoSettings(String mavenRepoSettings) {
        MAVEN_REPO_SETTINGS = mavenRepoSettings;
    }

    public static void setMavenName(String mavenName) {
        MAVEN_NAME = mavenName;
    }

    public static MavenStep classicDevelopBuildStep(String mavenGoal) {
        MavenStep mavenStep = new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + MAVEN_REPO_SETTINGS);
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep classicDevelopBuildStep(String mavenGoal, String mavenConfig) {
        MavenStep mavenStep = new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + MAVEN_REPO_SETTINGS, "", mavenConfig);
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep classicDevelopBuildStep(ConnectorConfiguration connector) {
        MavenStep mavenStep = new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep classicDevelopBuildStep(ConnectorConfiguration connector, String activeConfig) {
        MavenStep mavenStep = new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent -Dactiveconfiguration=" + activeConfig + " " + connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep classicMasterBuildStep(ConnectorConfiguration connector) {
        MavenStep mavenStep = new MavenStep(" -B clean " + (String)Objects.firstNonNull((Object)connector.getTestingConfigurationForMaster(), (Object)connector.getTestingConfiguration()) + " -Dmule.testingMode=true" + MAVEN_REPO_SETTINGS, connector.getJvmOptions());
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep sonarStep() {
        MavenStep mavenStep = new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dappend=true");
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep newSonarStep() {
        MavenStep mavenStep = new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dappend=true -Dsonar.host.url=https://sonar-tools.mulesoft.com/ -Dsonar.login=$SONAR_USERNAME -Dsonar.password=$SONAR_PASSWORD");
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep newSonarPRBuilderStep(ConnectorConfiguration connector) {
        GithubSSHURLParser githubSSHURLParser = new GithubSSHURLParser(connector.getGitHubUrl());
        String repoUrl = githubSSHURLParser.getGithubUser() + "/" + githubSSHURLParser.getGithubRepository();
        MavenStep mavenStep = new MavenStep(" -B org.codehaus.mojo:sonar-maven-plugin:2.6:sonar -Dsonar.host.url=https://sonar-tools.mulesoft.com/ -Dsonar.login=$SONAR_USERNAME -Dsonar.password=$SONAR_PASSWORD -Dsonar.analysis.mode=preview -Dsonar.github.oauth=$SONAR_GITHUB_OAUTH -Dsonar.github.pullRequest=$ghprbPullId -Dsonar.github.repository=" + repoUrl);
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep deployStep() {
        return StepBuilder.deployStep("");
    }

    public static MavenStep deployStep(String customParameters) {
        MavenStep mavenStep = new MavenStep(" -B deploy -DskipTests" + customParameters);
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep cleanStep() {
        MavenStep mavenStep = new MavenStep(" -B clean");
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep packageWithoutTestsStep() {
        MavenStep mavenStep = new MavenStep(" -B clean package -Dmaven.test.skip");
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep ctfCleanBuildStep(ConnectorConfiguration connector, String muleVersion, String branch) {
        return StepBuilder.ctfCleanBuildStep(connector, muleVersion, branch, null);
    }

    public static MavenStep ctfCleanBuildStep(ConnectorConfiguration connector, String muleVersion, String branch, String activeConfig) {
        String testingConfig = (String)Objects.firstNonNull((Object)("master".equals(branch) ? connector.getTestingConfigurationForMaster() : null), (Object)connector.getTestingConfiguration());
        String activeConfigParameter = StringUtils.isBlank((CharSequence)activeConfig) ? "" : " -Dactiveconfiguration=" + activeConfig;
        MavenStep mavenStep = new MavenStep(MAVEN_CLEAN + testingConfig + activeConfigParameter + MAVEN_REPO_SETTINGS + " -Ddeploymentprofile=local -Dmuledirectory=" + connector.getOverrideMuleLocation() + muleVersion + " -Dsurefire.reportNameSuffix=" + muleVersion, connector.getJvmOptions());
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static MavenStep cloudHubBuildStep(ConnectorConfiguration connector) {
        MavenStep mavenStep = new MavenStep(connector.getTestingConfiguration() + MAVEN_REPO_SETTINGS + " -Ddeploymentprofile=cloudhub -Dcloudhubuser=${cloudhubuser} -Dcloudhubpassword=${cloudhubpassword} -Dsurefire.reportNameSuffix=cloudhub", connector.getJvmOptions());
        mavenStep.setMavenName(MAVEN_NAME);
        return mavenStep;
    }

    public static ShellStep getEnableJceSteps() {
        return new ShellStep("if [ \\! -d $HOME/jdk6jce ]\nthen\n  cp -Lr /opt/jdk/jdk1.6.latest/ $HOME/jdk6jce\nfi\ncp -f /private/**/jce/jce6/*.jar $HOME/jdk6jce/jre/lib/security\n\nif [ \\! -d $HOME/jdk7jce ]\nthen\n  cp -Lr /opt/jdk/jdk1.7.latest/ $HOME/jdk7jce\nfi\ncp -f /private/**/jce/jce7/*.jar $HOME/jdk7jce/jre/lib/security\n\nif [ \\! -d $HOME/jdk8jce ]\nthen\n  cp -Lr /opt/jdk/jdk8.latest/ $HOME/jdk8jce\nfi\ncp -f /private/**/jce/jce8/*.jar $HOME/jdk8jce/jre/lib/security\n\n");
    }

    @Deprecated
    public static ShellStep unzipMuleStandaloneStep(String muleVersion) {
        return new ShellStep("if [ \\! -d " + muleVersion + " ]\nthen\nunzip /private/mule-connectors/mules/" + muleVersion + ".zip\nfi\n");
    }

    public static ShellStep unzipMuleStandaloneStep(String muleVersion, String muleLocation) {
        return new ShellStep("if [ \\! -d " + muleVersion + " ]\nthen\nunzip " + muleLocation + "\nfi\n");
    }

    public static ShellStep getUpdateMuleConfForJceEnabledJavaSteps() {
        return new ShellStep("sed -i.bak s?wrapper.java.command=/opt/jdk/jdk1.6.latest/bin/java?wrapper.java.command=$HOME/jdk6jce/jre/bin/java?g **/conf/wrapper.conf\nsed -i.bak s?wrapper.java.command=/opt/jdk/jdk1.7.latest/bin/java?wrapper.java.command=$HOME/jdk7jce/jre/bin/java?g **/conf/wrapper.conf\nsed -i.bak s?wrapper.java.command=/opt/jdk/jdk8.latest/bin/java?wrapper.java.command=$HOME/jdk8jce/jre/bin/java?g **/conf/wrapper.conf\n");
    }

    public static String stepsToString(JenkinsModel ... steps) {
        String stringSteps = "";
        for (JenkinsModel step : steps) {
            stringSteps = stringSteps.concat(step.getXmlConfig());
        }
        return stringSteps;
    }
}

