/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GithubSSHURLParser {
    private static final String SSH_URL_PATTERN_REGEX = "git@github.com:([\\w\\W]+)/([\\w\\W]+).git";
    private static final String HTTPS_URL_FORMAT = "https://github.com/%s/%s/";
    private static final Pattern SSH_URL_PATTERN = Pattern.compile("git@github.com:([\\w\\W]+)/([\\w\\W]+).git");
    private String sshUrl;
    private String githubUser;
    private String githubRepository;

    public GithubSSHURLParser(String sshUrl) {
        this.sshUrl = sshUrl;
        Matcher matcher = SSH_URL_PATTERN.matcher(sshUrl);
        if (!matcher.find()) {
            throw new RuntimeException(String.format("The given SSH URL [%s] is invalid", sshUrl));
        }
        this.githubUser = matcher.group(1);
        this.githubRepository = matcher.group(2);
    }

    public String getGithubUser() {
        return this.githubUser;
    }

    public String getGithubRepository() {
        return this.githubRepository;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public String getHttpsUrl() {
        return String.format(HTTPS_URL_FORMAT, this.getGithubUser(), this.getGithubRepository());
    }

    public static String toHttpsURL(String sshUrl) {
        return new GithubSSHURLParser(sshUrl).getHttpsUrl();
    }
}

