/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.models.step;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.util.StringUtils;

public class PropertiesFileStep
implements JenkinsStep {
    public static final String DEFAULT_FILE_LOCATION = "src/test/resources/";
    public static final String DEFAULT_FILE_NAME = "automation-credentials.properties";
    private static final int MAX_CHAR_LENGTH = 80;
    private byte[] contents;
    private String location = "src/test/resources/";
    private String fileName = "automation-credentials.properties";

    public PropertiesFileStep(String fileContents) {
        this.contents = fileContents.getBytes();
    }

    public PropertiesFileStep(String fileContents, String fileName) {
        this.fileName = fileName;
        this.contents = fileContents.getBytes();
    }

    public PropertiesFileStep(File file) throws IOException {
        this.contents = IOUtils.toByteArray((InputStream)new FileInputStream(file));
        this.fileName = file.getName();
    }

    public PropertiesFileStep(InputStream fileContents) throws IOException {
        this.contents = IOUtils.toByteArray((InputStream)fileContents);
    }

    private PropertiesFileStep(Builder builder) {
        this.contents = builder.contents;
        this.fileName = builder.fileName;
        this.location = builder.location;
    }

    @Override
    public String getXmlConfig() {
        Path outputPath = Paths.get(this.location, this.fileName);
        String base64Contents = Base64.encodeBase64String((byte[])this.contents);
        String shellFormat = "echo \"%s\" | \\\nbase64 --decode > %s";
        String shellCommand = String.format(shellFormat, StringUtils.reduceWithNewlines(base64Contents, 80), outputPath.toString());
        return new ShellStep(shellCommand).getXmlConfig();
    }

    public static class Builder {
        private final byte[] contents;
        private String location = "src/test/resources/";
        private String fileName = "automation-credentials.properties";

        public Builder(String contents) {
            this.contents = contents.getBytes();
        }

        public Builder(InputStream contents) throws IOException {
            this.contents = IOUtils.toByteArray((InputStream)contents);
        }

        public Builder(File file) throws IOException {
            this.contents = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            this.fileName = file.getName();
        }

        public Builder withLocation(String location) {
            if (location != null) {
                this.location = location;
            }
            return this;
        }

        public Builder withFileName(String fileName) {
            if (fileName != null) {
                this.fileName = fileName;
            }
            return this;
        }

        public PropertiesFileStep build() {
            return new PropertiesFileStep(this);
        }
    }
}

