/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;

public class MavenStep
implements JenkinsStep {
    private String mavenGoal;
    private String mavenName = "(Default)";
    private String jvmOptions;
    private String mavenSettingsId;

    public String getMavenGoal() {
        return this.mavenGoal;
    }

    public void setMavenGoal(String mavenGoal) {
        this.mavenGoal = mavenGoal;
    }

    public String getMavenName() {
        return this.mavenName;
    }

    public void setMavenName(String mavenName) {
        this.mavenName = mavenName;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public MavenStep(String mavenGoal, String jvmOptions) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
    }

    public MavenStep(String mavenGoal, String jvmOptions, String mavenSettingsId) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
        this.mavenSettingsId = mavenSettingsId;
    }

    public MavenStep(String mavenGoal) {
        this.mavenGoal = StringEscapeUtils.escapeXml((String)mavenGoal);
    }

    private String getJvmOptionsXml() {
        if (this.jvmOptions != null) {
            return "<jvmOptions>" + StringEscapeUtils.escapeXml((String)this.jvmOptions) + "</jvmOptions>\n";
        }
        return "";
    }

    @Override
    public String getXmlConfig() {
        return "    <hudson.tasks.Maven>\n      <targets>" + StringEscapeUtils.escapeXml((String)this.mavenGoal) + "</targets>\n      <mavenName>" + StringEscapeUtils.escapeXml((String)this.mavenName) + "</mavenName>\n" + this.getJvmOptionsXml() + "      <usePrivateRepository>false</usePrivateRepository>\n" + this.getConfigFileXml() + "    </hudson.tasks.Maven>";
    }

    protected String getConfigFileXml() {
        if (StringUtils.isNotBlank((String)this.mavenSettingsId)) {
            return "<settings class=\"org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider\" plugin=\"config-file-provider@3.3\">\n  <settingsConfigId>" + this.mavenSettingsId + "</settingsConfigId>\n</settings>\n";
        }
        return "";
    }
}

