/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cargo.container.configuration;

import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractRuntimeConfiguration;
import org.mule.tools.cargo.container.configuration.MuleConfigurationCapability;

public class IONConfiguration
extends AbstractRuntimeConfiguration {
    private static final String ION_URL_PROPERTY = "url";
    private static final String DOMAIN_PROPERTY = "domain";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String WORKERS_PROPERTY = "workers";
    private static final int WORKERS_DEFAULT = 1;
    private static final String MULE_VERSION = "muleVersion";
    private static final String MULE_VERSION_DEFAULT = "3.2.0";

    public ConfigurationCapability getCapability() {
        return new MuleConfigurationCapability();
    }

    public final String getIONURL() {
        return this.getPropertyValue(ION_URL_PROPERTY);
    }

    public final String getDomain() {
        return this.getPropertyValue(DOMAIN_PROPERTY);
    }

    public final String getUserName() {
        return this.getPropertyValue(USERNAME_PROPERTY);
    }

    public final String getPassword() {
        return this.getPropertyValue(PASSWORD_PROPERTY);
    }

    public final int getWorkers() {
        String workersProperty = this.getPropertyValue(WORKERS_PROPERTY);
        if (workersProperty == null) {
            return 1;
        }
        int workers = Integer.valueOf(workersProperty);
        if (workers < 0 || workers > 2) {
            throw new IllegalArgumentException("Workers must be >= 0 and <= 2");
        }
        return workers;
    }

    public final String getMuleVersion() {
        String muleVersion = this.getPropertyValue(MULE_VERSION);
        if (muleVersion == null) {
            return MULE_VERSION_DEFAULT;
        }
        return muleVersion;
    }

    protected final void ensurePropertyProvided(String property) {
        if (this.getPropertyValue(property) == null) {
            throw new IllegalArgumentException("Missing required " + property + " property");
        }
    }

    public final void validate() {
        this.ensurePropertyProvided(DOMAIN_PROPERTY);
        this.ensurePropertyProvided(USERNAME_PROPERTY);
        this.ensurePropertyProvided(PASSWORD_PROPERTY);
    }
}

