/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools.support;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.api.model.RepositoryPolicy;

public class MavenHelper {
    private static final String REPO_ID_LOCAL_AS_REMOTE = "local-as-remote";
    private static final String REPO_ID_MULESOFT_SNAPSHOTS = "mulesoft-snapshots";
    private static final String REPO_ID_MULESOFT_RELEASES = "mulesoft-releases";
    private static final String REPO_ID_MAVEN_CENTRAL = "central";
    private static final String REPO_URL_MULESOFT_SNAPSHOTS = "https://repository-master.mulesoft.org/nexus/content/repositories/snapshots/";
    private static final String REPO_URL_MULESOFT_RELEASES = "https://repository-master.mulesoft.org/nexus/content/repositories/releases/";
    private static final String REPO_URL_MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2/";

    public static File getM2Home() {
        return new File(System.getProperty("user.home"), ".m2");
    }

    public static File getM2LocalRepository() {
        return new File(MavenHelper.getM2Home(), "repository");
    }

    public static RemoteRepository createRemoteRepoFor(String id, String url) throws MalformedURLException {
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(new URL(url)).build();
    }

    public static RemoteRepository createRemoteRepoFor(String id, File file) throws MalformedURLException {
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(file.toURI().toURL()).build();
    }

    private static RemoteRepository createRemoteReleasesRepoFor(String id, String url) throws MalformedURLException {
        RepositoryPolicy disablePolicy = RepositoryPolicy.newRepositoryPolicyBuilder().enabled(false).build();
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(new URL(url)).build();
    }

    private static RemoteRepository createRemoteSnapshotsRepoFor(String id, String url) throws MalformedURLException {
        RepositoryPolicy disablePolicy = RepositoryPolicy.newRepositoryPolicyBuilder().enabled(false).build();
        return new RemoteRepository.RemoteRepositoryBuilder().id(id).url(new URL(url)).build();
    }

    public static MavenConfiguration.MavenConfigurationBuilder getBaseMavenConfBuilder(String settingsFile, String settingsSecurityFile, String localRepository, File localAsRemoteRepositoryPath, boolean offline, String checksumPolicy) throws IOException, MojoExecutionException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        mavenConfigurationBuilder.forcePolicyUpdateNever(true);
        if (StringUtils.isNotBlank((CharSequence)checksumPolicy)) {
            mavenConfigurationBuilder.globalChecksumPolicy(checksumPolicy);
        }
        mavenConfigurationBuilder.localMavenRepositoryLocation(new File(localRepository));
        MavenHelper.configureSettingsSecurity(mavenConfigurationBuilder, settingsSecurityFile);
        if (localAsRemoteRepositoryPath != null) {
            RemoteRepository localAsRemoteRepository = MavenHelper.createRemoteRepoFor(REPO_ID_LOCAL_AS_REMOTE, localAsRemoteRepositoryPath);
            mavenConfigurationBuilder.remoteRepository(localAsRemoteRepository);
        }
        if (!offline) {
            RemoteRepository snapshotsRepository = MavenHelper.createRemoteSnapshotsRepoFor(REPO_ID_MULESOFT_SNAPSHOTS, REPO_URL_MULESOFT_SNAPSHOTS);
            RemoteRepository releasesRepository = MavenHelper.createRemoteReleasesRepoFor(REPO_ID_MULESOFT_RELEASES, REPO_URL_MULESOFT_RELEASES);
            RemoteRepository central = MavenHelper.createRemoteReleasesRepoFor(REPO_ID_MAVEN_CENTRAL, REPO_URL_MAVEN_CENTRAL);
            mavenConfigurationBuilder.remoteRepository(snapshotsRepository);
            mavenConfigurationBuilder.remoteRepository(releasesRepository);
            mavenConfigurationBuilder.remoteRepository(central);
            mavenConfigurationBuilder.userSettingsLocation(new File(settingsFile));
        }
        return mavenConfigurationBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configureSettingsSecurity(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder, String settingsSecurityFile) throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)settingsSecurityFile)) {
            File defaultSettingsSecurity = new File(settingsSecurityFile);
            if (!defaultSettingsSecurity.exists()) throw new MojoExecutionException("Unable to resolve settings security file: " + settingsSecurityFile + ". Verify the file exists.");
            mavenConfigurationBuilder.settingsSecurityLocation(defaultSettingsSecurity);
            return;
        } else {
            File settingsSecurityLocation = new File(MavenHelper.getM2Home(), "settings-security.xml");
            if (!settingsSecurityLocation.exists()) return;
            mavenConfigurationBuilder.settingsSecurityLocation(settingsSecurityLocation);
        }
    }
}

