/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="replace-jars-in-bundle", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ReplaceJarsInBundleMojo
extends AbstractMojo {
    private static final String JAR = ".jar";
    private static final String EXTENSION = ".txt";
    private static final String PROVIDED = "__PROVIDED__";
    @Parameter(property="repositoryDirectory", required=true)
    public File repositoryDirectory;
    @Parameter(property="bundleDirectory", required=true)
    public File bundleDirectory;
    @Parameter(property="bundleRepositoryDirectory", required=true)
    public String bundleRepositoryDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (!this.repositoryDirectory.exists()) {
            throw new MojoFailureException("The repository directory " + this.repositoryDirectory.getAbsolutePath() + " does not exists");
        }
        if (!this.bundleDirectory.exists()) {
            throw new MojoFailureException("The bundle directory " + this.bundleDirectory.getAbsolutePath() + " does not exists");
        }
        File baseBundleDirectory = new File(this.bundleDirectory, this.bundleRepositoryDirectory);
        if (!baseBundleDirectory.exists()) {
            throw new MojoFailureException("The repository directory of the bundle " + baseBundleDirectory.getAbsolutePath() + " does not exists");
        }
        log.info((CharSequence)("Replacing jars in " + this.repositoryDirectory + " with the ones already present in " + this.bundleDirectory));
        HashMap<String, String> index = new HashMap<String, String>();
        this.index(this.bundleDirectory, baseBundleDirectory, index);
        try {
            this.replaceFiles(this.repositoryDirectory, index);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to replace jars", (Exception)e);
        }
        log.info((CharSequence)"Done replacing jars.");
    }

    private void index(File rootDirectory, File directory, Map<String, String> index) {
        File[] listFiles;
        for (File file : listFiles = directory.listFiles()) {
            if (!file.isDirectory()) {
                if (!file.getName().endsWith(JAR)) continue;
                String relativePath = file.getAbsolutePath().substring(rootDirectory.getAbsolutePath().length());
                index.put(file.getName(), relativePath);
                continue;
            }
            this.index(rootDirectory, file, index);
        }
    }

    private void replaceFiles(File repositoryDirectory, Map<String, String> index) throws IOException {
        File[] listFiles;
        for (File file : listFiles = repositoryDirectory.listFiles()) {
            if (!file.isDirectory()) {
                String fileName = file.getName();
                String pathInSource = index.get(fileName);
                if (pathInSource == null) continue;
                String replacementFileName = PROVIDED + fileName + "__PROVIDED__.txt";
                File replacementFile = new File(file.getParentFile(), replacementFileName);
                try (FileWriter fileWriter = new FileWriter(replacementFile);){
                    fileWriter.write(pathInSource);
                }
                file.delete();
                this.getLog().info((CharSequence)("Marked " + file.getAbsolutePath() + " for replacement with " + pathInSource));
                continue;
            }
            this.replaceFiles(file, index);
        }
    }
}

