package org.mule.tooling.extensions.metadata.internal.value.provider.sdk;

import static java.util.Collections.singleton;
import static org.mule.sdk.api.values.ValueBuilder.newValue;

import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.values.Value;
import org.mule.sdk.api.values.ValueProvider;
import org.mule.sdk.api.values.ValueResolvingException;
import org.mule.tooling.extensions.metadata.api.parameters.ComplexActingParameter;
import org.mule.tooling.extensions.metadata.api.parameters.InnerPojo;

import java.util.Set;

public class ComplexActingParameterVP implements ValueProvider {

  @Parameter
  private ComplexActingParameter actingParameter;

  @Override
  public Set<Value> resolve() throws ValueResolvingException {
    final StringBuilder stringBuilder = new StringBuilder();
    stringBuilder.append(actingParameter.getIntParam());
    if (actingParameter.getStringParam() != null) {
      stringBuilder.append(actingParameter.getStringParam());
    }
    if (actingParameter.getSimpleListParam() != null) {
      actingParameter.getSimpleListParam().forEach(stringBuilder::append);
    }
    if (actingParameter.getSimpleMapParam() != null) {
      actingParameter.getSimpleMapParam().forEach((k, v) -> stringBuilder.append(k).append(v));
    }
    if (actingParameter.getInnerPojoParam() != null) {
      appendInnerPojoValues(stringBuilder, actingParameter.getInnerPojoParam());
    }
    if (actingParameter.getComplexListParam() != null) {
      actingParameter.getComplexListParam().forEach(l -> appendInnerPojoValues(stringBuilder, l));
    }
    if (actingParameter.getComplexMapParam() != null) {
      actingParameter.getComplexMapParam().forEach((k, v) -> {
        stringBuilder.append(k);
        appendInnerPojoValues(stringBuilder, v);
      });
    }
    return singleton(newValue(stringBuilder.toString()).build());
  }

  private void appendInnerPojoValues(StringBuilder stringBuilder, InnerPojo innerPojo) {
    stringBuilder.append(innerPojo.getIntParam());
    if (innerPojo.getStringParam() != null) {
      stringBuilder.append(innerPojo.getStringParam());
    }
    if (innerPojo.getSimpleListParam() != null) {
      innerPojo.getSimpleListParam().forEach(stringBuilder::append);
    }
    if (innerPojo.getSimpleMapParam() != null) {
      innerPojo.getSimpleMapParam().forEach((k, v) -> stringBuilder.append(k).append(v));
    }
  }

  @Override
  public String getId() {
    return this.getClass().getSimpleName();
  }
}
