package org.mule.tooling.extensions.metadata.internal.value.provider.extensions;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.tooling.extensions.metadata.api.parameters.SimpleParametersContainer;

import java.util.Set;

import static java.util.Collections.singleton;
import static org.mule.runtime.extension.api.values.ValueBuilder.newValue;

public class SimpleParametersContainerVP implements ValueProvider {

    @Parameter
    private SimpleParametersContainer simpleParametersContainer;

    @Override
    public Set<Value> resolve() throws ValueResolvingException {
        return singleton(
            newValue(
                Integer.toString(simpleParametersContainer.getIntParam())
                    + Boolean.toString(simpleParametersContainer.getBooleanParam())
                    + simpleParametersContainer.getDateParam().toString()
                    + simpleParametersContainer.getSqlDateParam().toString()
                    + simpleParametersContainer.getLocalDateParam().toString()
                    + simpleParametersContainer.getLocalDateTimeParam().toString()
                    + simpleParametersContainer.getCalendarParam().toInstant().toString()
                    + simpleParametersContainer.getXmlGregorianCalendarParam().toString()
                    + simpleParametersContainer.getEnumParam().toString()
            ).build());
    }
}
