package org.mule.tooling.extensions.metadata.internal.metadata.sdk;

import static org.mule.metadata.api.model.MetadataFormat.XML;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;

import javax.xml.namespace.QName;

public class TypeWithAttributeResolver extends InputStaticTypeResolver {

  @Override
  public MetadataType getStaticMetadata() {
    StringTypeBuilder stringType = BaseTypeBuilder.create(XML).stringType();
    return BaseTypeBuilder
            .create(XML)
            .objectType()
            .addField()
            .value(stringType)
            .key(QName.valueOf("field"))
            .addAttribute()
            .name("attribute")
            .value(stringType)
            .build();
  }
}
