package org.mule.tooling.extensions.metadata.internal.metadata;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

import java.util.Set;

public class InternalErrorMetadataResolver implements TypeKeysResolver, OutputTypeResolver<String>, AttributesTypeResolver<String>, InputTypeResolver<String> {

  @Override
  public MetadataType getAttributesType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
    throw newInternalError();
  }

  private RuntimeException newInternalError() {
    return new RuntimeException(getResolverName() + " has thrown unexpected exception");
  }

  @Override
  public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
    throw newInternalError();
  }

  @Override
  public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
    throw newInternalError();
  }

  @Override
  public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
    throw newInternalError();
  }

  @Override
  public String getCategoryName() {
    return getResolverName();
  }

  @Override
  public String getResolverName() {
    return InternalErrorMetadataResolver.class.getSimpleName();
  }
}
