package org.mule.tooling.extensions.metadata.internal.value.provider.extensions;

import static java.util.Collections.singleton;
import static org.mule.runtime.extension.api.values.ValueBuilder.newValue;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

import javax.xml.datatype.XMLGregorianCalendar;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SimpleActingParametersVP implements ValueProvider {

    @Parameter
    private int intParam;

    @Parameter
    private boolean booleanParam;

    @Parameter
    private Date dateParam;

    @Parameter
    private java.sql.Date sqlDateParam;

    @Parameter
    private LocalDate localDateParam;

    @Parameter
    private LocalDateTime localDateTimeParam;

    @Parameter
    private Calendar calendarParam;

    @Parameter
    private XMLGregorianCalendar xmlGregorianCalendarParam;

    @Parameter
    private TimeUnit enumParam;

    @Override
    public Set<Value> resolve() throws ValueResolvingException {
        return singleton(
            newValue(
                    Integer.toString(intParam)
                    + Boolean.toString(booleanParam)
                    + dateParam.toString()
                    + sqlDateParam.toString()
                    + localDateParam.toString()
                    + localDateTimeParam.toString()
                    + calendarParam.toInstant().toString()
                    + xmlGregorianCalendarParam.toString()
                    + enumParam.toString()
            ).build());
    }
}
