/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.extensions.metadata.internal.sampledata;

import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.tooling.extensions.metadata.api.parameters.ComplexActingParameter;
import org.mule.tooling.extensions.metadata.api.parameters.InnerPojo;

public class ComplexActingParameterSampleDataProvider implements SampleDataProvider<Integer, String> {

  @Parameter
  private ComplexActingParameter actingParameter;

  @Override
  public String getId() {
    return getClass().getSimpleName();
  }

  @Override
  public Result<Integer, String> getSample() throws SampleDataException {

    StringBuilder sb = new StringBuilder();
    sb.append(actingParameter.getIntParam());
    if (actingParameter.getStringParam() != null) {
      sb.append(actingParameter.getStringParam());
    }
    if (actingParameter.getSimpleListParam() != null) {
      actingParameter.getSimpleListParam().forEach(sb::append);
    }
    if (actingParameter.getSimpleMapParam() != null) {
      actingParameter.getSimpleMapParam().forEach((k, v) -> sb.append(k).append(v));
    }
    if (actingParameter.getInnerPojoParam() != null) {
      appendInnerPojoValues(sb, actingParameter.getInnerPojoParam());
    }
    if (actingParameter.getComplexListParam() != null) {
      actingParameter.getComplexListParam().forEach(l -> appendInnerPojoValues(sb, l));
    }
    if (actingParameter.getComplexMapParam() != null) {
      actingParameter.getComplexMapParam().forEach((k, v) -> {
        sb.append(k);
        appendInnerPojoValues(sb, v);
      });
    }
    return Result.<Integer, String>builder().attributes(sb.toString()).build();
  }

  private void appendInnerPojoValues(StringBuilder stringBuilder, InnerPojo innerPojo) {
    stringBuilder.append(innerPojo.getIntParam());
    if (innerPojo.getStringParam() != null) {
      stringBuilder.append(innerPojo.getStringParam());
    }
    if (innerPojo.getSimpleListParam() != null) {
      innerPojo.getSimpleListParam().forEach(stringBuilder::append);
    }
    if (innerPojo.getSimpleMapParam() != null) {
      innerPojo.getSimpleMapParam().forEach((k, v) -> stringBuilder.append(k).append(v));
    }
  }

}
