package org.mule.tooling.extensions.metadata.internal.metadata;

import static java.util.Collections.emptySet;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

import java.util.Optional;
import java.util.Set;

public class OutputTypeKeyResolverUsesResourcesCache implements TypeKeysResolver, OutputTypeResolver<String> {

  private static final String CACHE_KEY = "CacheKey";

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, String key) throws MetadataResolvingException, ConnectionException {
    Optional<String> currentCacheEntry = metadataContext.getCache().get(CACHE_KEY);

    String defaultValue = currentCacheEntry.map(actual -> actual + " " + key).orElse(key);

    metadataContext.getCache().put(CACHE_KEY, defaultValue);

    return BaseTypeBuilder.create(JAVA).stringType().defaultValue(defaultValue).build();
  }

  @Override
  public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
    return emptySet();
  }

  @Override
  public String getResolverName() {
    return this.getClass().getName();
  }

  @Override
  public String getCategoryName() {
    return this.getResolverName();
  }

}
