package org.mule.tooling.extensions.metadata.internal.metadata;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelPartialTypeKeysOutputTypeResolver.resolveLocationKeyChildren;
import static org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver.buildAmericaKey;
import static org.mule.tooling.extensions.metadata.internal.metadata.MultiLevelTypeKeysOutputTypeResolver.buildEuropeKey;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKey;
import org.mule.tooling.extensions.metadata.api.parameters.LocationKeyAllOptionals;

import java.util.LinkedHashSet;
import java.util.Set;

public class LocationAllOptionalsMetadataResolver implements OutputTypeResolver<LocationKeyAllOptionals>, AttributesTypeResolver<LocationKeyAllOptionals> {

  @Override
  public MetadataType getAttributesType(MetadataContext metadataContext, LocationKeyAllOptionals locationKey) {
    return BaseTypeBuilder.create(JAVA).stringType().defaultValue(locationKey.toString()).build();
  }

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, LocationKeyAllOptionals locationKey) {
    return BaseTypeBuilder.create(JAVA).stringType().defaultValue(locationKey.toString()).build();
  }

  @Override
  public String getResolverName() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String getCategoryName() {
    return "LOC";
  }

  public static class WithKeyResolver extends LocationAllOptionalsMetadataResolver implements TypeKeysResolver {

    @Override
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
      Set<MetadataKey> keys = new LinkedHashSet<>();
      keys.add(buildEuropeKey());
      keys.add(buildAmericaKey());
      return keys;
    }
  }

  public static class WithPartialKeyResolver extends WithKeyResolver implements PartialTypeKeysResolver<LocationKey> {

    @Override
    public MetadataKey resolveChilds(MetadataContext metadataContext, LocationKey locationKey) throws MetadataResolvingException {
      return resolveLocationKeyChildren(locationKey);
    }
  }

}
