/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.sampledata;

import java.nio.charset.Charset;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.internal.sampledata.SampleDataContentLimitSerializationException;
import org.mule.tooling.internal.sampledata.SampleDataSerializationException;
import org.mule.tooling.internal.utils.MuleEventTransformer;

public class SampleDataResultTransformer {
    public static SampleDataMessageModelResult toComponentSampleDataResult(SampleDataResult sampleDataResult, ExpressionLanguage expressionLanguage, long maxPayloadSize) {
        if (sampleDataResult.isSuccess()) {
            MessageModel messageModel = null;
            long maxCollectionSize = -1L;
            try {
                messageModel = MuleEventTransformer.buildMessageModel((Message)sampleDataResult.getSampleData().get(), maxPayloadSize, maxCollectionSize, expressionLanguage, Charset.defaultCharset(), true);
                return new SampleDataMessageModelResult(messageModel);
            }
            catch (SampleDataContentLimitSerializationException e) {
                return new SampleDataMessageModelResult(new SampleDataMessageModelFailure("Content size is too large", e.getMessage(), "CONTENT_LIMIT_ERROR"));
            }
            catch (SampleDataSerializationException e) {
                return new SampleDataMessageModelResult(new SampleDataMessageModelFailure("Sample Data serialization error", e.getMessage(), "SERIALIZATION_ERROR"));
            }
        }
        SampleDataFailure sampleDataFailure = (SampleDataFailure)sampleDataResult.getFailure().get();
        return new SampleDataMessageModelResult(new SampleDataMessageModelFailure(sampleDataFailure.getMessage(), sampleDataFailure.getReason(), sampleDataFailure.getFailureCode()));
    }
}

