/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.ErrorModel;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.tooling.internal.sampledata.SampleDataContentLimitSerializationException;
import org.mule.tooling.internal.sampledata.SampleDataSerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleEventTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleEventTransformer.class);
    private static final Boolean MARK_SUCCESSFUL = true;
    private static final String DW_VERSION = "%dw 2.0";
    private static final String DW_DEFAULT_HEADER = "output application/dw ignoreSchema=true";
    private static final String DW_WITH_MAX_COLLECTIONS_HEADER = "output application/dw ignoreSchema=true, maxCollectionSize=%s";
    private static final String DW_TRANSFORMATION = "payload dw::util::Tree::filterTree ((value) -> !(value is Binary) or (value.^class == \"byte[]\"))";
    private static final String PAYLOAD_ID = "payload";

    public static EventModel getEventModel(Event event, ExpressionLanguage expressionLanguage, long maxPayloadSize, long maxCollectionSize, Charset defaultEncoding) {
        if (event.getMessage() == null) {
            return null;
        }
        return EventModel.builder().withMessage(MuleEventTransformer.buildMessageModel(event.getMessage(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, false)).withVariables(MuleEventTransformer.toTypedValueVariables(event.getVariables(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding)).withError(MuleEventTransformer.getErrorModel(event.getError(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding), MARK_SUCCESSFUL.booleanValue()).build();
    }

    public static MessageModel buildMessageModel(Message message, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean sampleData) {
        if (message == null) {
            return null;
        }
        return MessageModel.builder().withAttributes(MuleEventTransformer.transformTypedValue(message.getAttributes(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, sampleData)).withPayload(MuleEventTransformer.transformTypedValue(message.getPayload(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, sampleData)).build();
    }

    private static ErrorModel getErrorModel(Optional<Error> errorOptional, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding) {
        return errorOptional.map(error -> ErrorModel.builder().withDescription(error.getDescription()).withDetailedDescription(error.getDetailedDescription()).withType(error.getErrorType().getNamespace() + ":" + error.getErrorType().getIdentifier()).withExceptionType(error.getCause().getClass().getName()).withMessage(MuleEventTransformer.buildMessageModel(error.getErrorMessage(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, false)).build()).orElse(null);
    }

    private static byte[] createByteArrayFromInputStream(InputStream input) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)input, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not close stream", (Throwable)e);
            }
        }
    }

    private static TypedValueModel transformTypedValue(TypedValue typedValue, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean sampleData) {
        if (typedValue == null) {
            return null;
        }
        TypedValueModel.Builder typedValueModelBuilder = TypedValueModel.builder();
        if (typedValue.getValue() == null) {
            typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(typedValue.getDataType().getMediaType().toRfcString()).build());
        } else {
            try {
                Charset outputEncoding = typedValue.getDataType().getMediaType().getCharset().orElse(defaultEncoding);
                typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(typedValue.getDataType().getMediaType().toRfcString()).build());
                byte[] content = null;
                if (DataType.CURSOR_STREAM_PROVIDER.isCompatibleWith(typedValue.getDataType()) || typedValue.getValue() instanceof CursorStreamProvider) {
                    content = MuleEventTransformer.createByteArrayFromInputStream((InputStream)((CursorStreamProvider)typedValue.getValue()).openCursor());
                } else if (DataType.INPUT_STREAM.isCompatibleWith(typedValue.getDataType()) || typedValue.getValue() instanceof InputStream) {
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(MediaType.create((String)typedValue.getDataType().getMediaType().getPrimaryType(), (String)typedValue.getDataType().getMediaType().getSubType(), (Charset)outputEncoding).toRfcString()).build());
                    if (sampleData) {
                        content = MuleEventTransformer.createByteArrayFromInputStream((InputStream)typedValue.getValue());
                    } else {
                        LOGGER.info(String.format("%s cannot be consumed there tracking event won't have a preview for this typedValue", typedValue.getDataType()));
                        typedValueModelBuilder.withTruncated(true);
                    }
                } else if (DataType.BYTE_ARRAY.isCompatibleWith(typedValue.getDataType()) && typedValue.getValue() instanceof byte[]) {
                    content = (byte[])typedValue.getValue();
                } else if (DataType.OBJECT.isCompatibleWith(typedValue.getDataType()) && typedValue.getValue() instanceof String) {
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(MediaType.create((String)typedValue.getDataType().getMediaType().getPrimaryType(), (String)typedValue.getDataType().getMediaType().getSubType(), (Charset)outputEncoding).toRfcString()).build());
                    content = String.valueOf(typedValue.getValue()).getBytes(outputEncoding);
                } else {
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withMediaType(MediaType.create((String)"application", (String)"dw", (Charset)outputEncoding).toRfcString()).withType(DataType.STRING.getType().getName()).build());
                    BindingContext.Builder bindingBuilder = BindingContext.builder();
                    bindingBuilder.addBinding(PAYLOAD_ID, typedValue);
                    String script = MuleEventTransformer.getDataWeaveScript(maxCollectionSize);
                    TypedValue weaveResult = expressionLanguage.evaluate(script, bindingBuilder.build());
                    content = DataType.CURSOR_STREAM_PROVIDER.isCompatibleWith(weaveResult.getDataType()) || weaveResult.getValue() instanceof CursorStreamProvider ? MuleEventTransformer.createByteArrayFromInputStream((InputStream)((CursorStreamProvider)weaveResult.getValue()).openCursor()) : String.valueOf(weaveResult.getValue()).getBytes(outputEncoding);
                }
                if (maxPayloadSize != -1L && content != null && (long)content.length > maxPayloadSize) {
                    String message = String.format("Content size of %d bytes exceeds allowed maximum of %d bytes", content.length, maxPayloadSize);
                    if (sampleData) {
                        throw new SampleDataContentLimitSerializationException(message);
                    }
                    LOGGER.info(message);
                    typedValueModelBuilder.withTruncated(true).withContent(null);
                } else {
                    typedValueModelBuilder.withContent(content);
                }
            }
            catch (SampleDataSerializationException e) {
                LOGGER.info(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (sampleData) {
                    throw new SampleDataSerializationException(e);
                }
                typedValueModelBuilder.withTruncated(true).withContent(null);
            }
        }
        return typedValueModelBuilder.build();
    }

    private static String getDataWeaveScript(long maxCollectionSize) {
        String header = maxCollectionSize != -1L ? String.format(DW_WITH_MAX_COLLECTIONS_HEADER, maxCollectionSize) : DW_DEFAULT_HEADER;
        return String.format("%s\n%s\n---\n%s", DW_VERSION, header, DW_TRANSFORMATION);
    }

    private static Map<String, TypedValueModel> toTypedValueVariables(Map<String, TypedValue<?>> variables, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding) {
        HashMap<String, TypedValueModel> result = new HashMap<String, TypedValueModel>();
        variables.forEach((name, value) -> result.put((String)name, MuleEventTransformer.transformTypedValue(value, maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, false)));
        return result;
    }
}

