/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.handler.session;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.tooling.TestConnectionStatus;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.extension.api.persistence.metadata.ComponentMetadataTypesDescriptorResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.metadata.MetadataKeysResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.value.ValueResultJsonSerializer;
import org.mule.runtime.module.repository.api.BundleNotFoundException;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;
import org.mule.tooling.api.request.session.DeclarationSessionCreationRequest;
import org.mule.tooling.api.request.session.model.Dependency;
import org.mule.tooling.api.request.values.FieldValuesRequest;
import org.mule.tooling.api.request.values.ValuesRequest;
import org.mule.tooling.api.serialization.Serializer;
import org.mule.tooling.api.serialization.SerializerFactory;
import org.mule.tooling.api.service.Configuration;
import org.mule.tooling.api.service.expression.RuntimeAgentService;
import org.mule.tooling.api.service.session.DeclarationSessionAgentService;
import org.mule.tooling.api.service.session.DeclarationSessionContainer;
import org.mule.tooling.internal.handler.LoggingHandler;
import org.mule.tooling.internal.sampledata.SampleDataResultTransformer;

@Singleton
@Named(value="org.mule.tooling.handler")
@Path(value="/tooling")
public class DeclarationSessionsAgentHandler
implements ExternalMessageHandler,
LoggingHandler {
    private static final String IGNORE_CACHE_QUERY_PARAM = "ignoreCache";
    private static final String VERBOSE_QUERY_PARAM = "verbose";
    private static final String BASE_SESSIONS_PATH = "/declaration-sessions";
    private Serializer serializer = SerializerFactory.jsonSerializer();
    @Inject
    private DeclarationSessionAgentService declarationSessionService;
    @Inject
    private RuntimeAgentService runtimeAgentService;
    @Inject
    private Configuration configuration;
    private AtomicBoolean enabled = new AtomicBoolean();
    private ResponseHelper responseHelper = new ResponseHelper().addErrorMapping(BundleNotFoundException.class, Response.Status.BAD_REQUEST);

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabled.set(state);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    @POST
    @Path(value="/declaration-sessions")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createSession(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, String declarationSessionCreationRequestString, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            try {
                DeclarationSessionCreationRequest sessionCreationRequest = this.serializer.deserialize(declarationSessionCreationRequestString, DeclarationSessionCreationRequest.class);
                DeclarationSessionContainer configService = this.declarationSessionService.createDeclarationSession(this.toMuleDependencies(sessionCreationRequest.getDependencies()), sessionCreationRequest.getArtifactDeclaration(), sessionCreationRequest.getSessionProperties());
                return this.responseHelper.response(configService::getId, verboseErrors);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), e, verboseErrors);
            }
        });
    }

    private List<ArtifactAgnosticServiceBuilder.Dependency> toMuleDependencies(List<Dependency> dependencies) {
        return dependencies.stream().map(d -> {
            ArtifactAgnosticServiceBuilder.Dependency dependency = new ArtifactAgnosticServiceBuilder.Dependency();
            dependency.setArtifactId(d.getArtifactId());
            dependency.setClassifier(d.getClassifier());
            dependency.setExclusions(d.getExclusions().stream().map(e -> {
                ArtifactAgnosticServiceBuilder.Exclusion exclusion = new ArtifactAgnosticServiceBuilder.Exclusion();
                exclusion.setArtifactId(e.getArtifactId());
                exclusion.setGroupId(e.getGroupId());
                return exclusion;
            }).collect(Collectors.toList()));
            dependency.setGroupId(d.getGroupId());
            dependency.setOptional(d.getOptional());
            dependency.setScope(d.getScope());
            dependency.setSystemPath(d.getSystemPath());
            dependency.setType(d.getType());
            dependency.setVersion(d.getVersion());
            return dependency;
        }).collect(Collectors.toList());
    }

    @DELETE
    @Path(value="/declaration-sessions/{sessionId}")
    public boolean deleteSession(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId) {
        return (Boolean)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> this.declarationSessionService.deleteSession(sessionId));
    }

    @GET
    @Path(value="/declaration-sessions/{sessionId}/connection")
    @Produces(value={"application/json"})
    public Response testConnection(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, @QueryParam(value="configName") String configName, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> this.declarationSessionService.getSession(sessionId).map(sc -> this.responseHelper.response(() -> this.serializer.serialize(TestConnectionStatus.testConnectionResult((ConnectionValidationResult)sc.getSession().testConnection(configName), (boolean)true)), verboseErrors)).orElseGet(() -> this.sessionNotFoundResponse(sessionId)));
    }

    private Response sessionNotFoundResponse(String sessionId) {
        return this.responseHelper.failure(Response.Status.NOT_FOUND, String.format("No session found for id: '%s'", sessionId), (Exception)new IllegalArgumentException("No session found"), false);
    }

    @PUT
    @Path(value="/declaration-sessions/{sessionId}/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getValues(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, String valuesRequestString, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            ValuesRequest valuesRequest;
            try {
                valuesRequest = this.serializer.deserialize(valuesRequestString, ValuesRequest.class);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "Body is not valid json", e, verboseErrors);
            }
            if (!valuesRequest.getParameterizedElementDeclaration().isPresent()) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "No parameterized element declaration found in request", (Exception)new IllegalStateException("Invalid ValuesRequest"), verboseErrors);
            }
            return this.declarationSessionService.getSession(sessionId).map(sc -> this.responseHelper.response(() -> new ValueResultJsonSerializer().serialize(sc.getSession().getValues(valuesRequest.getParameterizedElementDeclaration().get(), valuesRequest.getProviderName())), verboseErrors)).orElseGet(() -> this.sessionNotFoundResponse(sessionId));
        });
    }

    @PUT
    @Path(value="/declaration-sessions/{sessionId}/fieldValues")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFieldValues(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, String valuesRequestString, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            FieldValuesRequest fieldValuesRequest;
            try {
                fieldValuesRequest = this.serializer.deserialize(valuesRequestString, FieldValuesRequest.class);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "Body is not valid json", e, verboseErrors);
            }
            if (fieldValuesRequest.getComponentElementDeclaration() == null) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "No component element declaration found in request", (Exception)new IllegalStateException("Invalid FieldValuesRequest"), verboseErrors);
            }
            return this.declarationSessionService.getSession(sessionId).map(sc -> this.responseHelper.response(() -> new ValueResultJsonSerializer().serialize(sc.getSession().getFieldValues(fieldValuesRequest.getComponentElementDeclaration(), fieldValuesRequest.getProviderName(), fieldValuesRequest.getTargetSelector())), verboseErrors)).orElseGet(() -> this.sessionNotFoundResponse(sessionId));
        });
    }

    @PUT
    @Path(value="/declaration-sessions/{sessionId}/component/metadata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response componentMetadata(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, String componentElementDeclarationString, @QueryParam(value="ignoreCache") boolean ignoreCache, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            ComponentElementDeclaration componentElementDeclaration;
            try {
                componentElementDeclaration = this.serializer.deserialize(componentElementDeclarationString, ComponentElementDeclaration.class);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "Body is not a valid json", e, verboseErrors);
            }
            return this.declarationSessionService.getSession(sessionId).map(sc -> {
                if (ignoreCache) {
                    sc.getSession().disposeMetadataCache(componentElementDeclaration);
                }
                return this.responseHelper.response(() -> this.getComponentMetadataTypesDescriptorResultJsonSerializer().serialize(sc.getSession().resolveComponentMetadata(componentElementDeclaration)), verboseErrors);
            }).orElseGet(() -> this.sessionNotFoundResponse(sessionId));
        });
    }

    @PUT
    @Path(value="/declaration-sessions/{sessionId}/component/metadata/keys")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response metadataKeys(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, String componentElementDeclarationString, @QueryParam(value="ignoreCache") boolean ignoreCache, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            ComponentElementDeclaration componentElementDeclaration;
            try {
                componentElementDeclaration = this.serializer.deserialize(componentElementDeclarationString, ComponentElementDeclaration.class);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "Body is not a valid json", e, verboseErrors);
            }
            return this.declarationSessionService.getSession(sessionId).map(sc -> {
                if (ignoreCache) {
                    sc.getSession().disposeMetadataCache(componentElementDeclaration);
                }
                return this.responseHelper.response(() -> new MetadataKeysResultJsonSerializer().serialize(sc.getSession().getMetadataKeys(componentElementDeclaration)), verboseErrors);
            }).orElseGet(() -> this.sessionNotFoundResponse(sessionId));
        });
    }

    @PUT
    @Path(value="/declaration-sessions/{sessionId}/component/sampledata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSampleData(@HeaderParam(value="X-B3-TraceId") String requestIdHeader, @PathParam(value="sessionId") String sessionId, String componentElementDeclarationString, @QueryParam(value="verbose") boolean verboseErrors) {
        return (Response)this.withLoggingContext(Optional.ofNullable(requestIdHeader), () -> {
            ComponentElementDeclaration componentElementDeclaration;
            try {
                componentElementDeclaration = this.serializer.deserialize(componentElementDeclarationString, ComponentElementDeclaration.class);
            }
            catch (Exception e) {
                return this.responseHelper.failure(Response.Status.BAD_REQUEST, "Body is not a valid json", e, verboseErrors);
            }
            return this.declarationSessionService.getSession(sessionId).map(sc -> this.responseHelper.response(() -> this.serializer.serialize(SampleDataResultTransformer.toComponentSampleDataResult(sc.getSession().getSampleData(componentElementDeclaration), this.runtimeAgentService.getExpressionLanguage(), this.configuration.getSampleDataMaxPayloadSize())), verboseErrors)).orElseGet(() -> this.sessionNotFoundResponse(sessionId));
        });
    }

    private ComponentMetadataTypesDescriptorResultJsonSerializer getComponentMetadataTypesDescriptorResultJsonSerializer() {
        return new ComponentMetadataTypesDescriptorResultJsonSerializer(false, true);
    }
}

