/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.sampledata;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;
import static org.apache.commons.lang3.builder.ToStringStyle.JSON_STYLE;
import static org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace;

/**
 * Immutable representation of an error that occurred during sample data resolution.
 *
 * @since 4.4.0
 */
public class SampleDataMessageModelFailure {

  private final String message;
  private final String reason;
  private final String failureCode;

  public SampleDataMessageModelFailure(String message, String reason, String failureCode) {
    this.message = message;
    this.reason = reason;
    this.failureCode = failureCode;
  }

  public SampleDataMessageModelFailure(Exception e) {
    this(e.getMessage(), getStackTrace(e), "UNKNOWN");
  }

  /**
   * @return a custom message describing the context in which the failure occurred
   */
  public String getMessage() {
    return message;
  }

  /**
   * @return the {@link String} of the error that occurred
   */
  public String getFailureCode() {
    return failureCode;
  }

  /**
   * @return the original message of the error that produced this failure
   */
  public String getReason() {
    return reason;
  }

  @Override
  public String toString() {
    return reflectionToString(this, JSON_STYLE);
  }

}
