/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.serialization;

import static org.mule.runtime.app.declaration.serialization.impl.gson.GsonElementDeclarationJsonSerializer.configureGsonForElementDeclaration;
import org.mule.tooling.internal.serialization.json.JsonSerializer;

import com.google.gson.GsonBuilder;

public class SerializerFactory {

  public static Serializer jsonSerializer() {
    GsonBuilder gsonBuilder = configureGsonForElementDeclaration(new GsonBuilder());
    return new JsonSerializer(gsonBuilder.create());
  }

}
