/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.request.session;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.api.request.session.model.Dependency;

import java.util.List;
import java.util.Map;

/**
 * Request for creating a declaration session in order to resolve services such connectivity testing, values, metadata.
 */
public class DeclarationSessionCreationRequest {

  private final ArtifactDeclaration artifactDeclaration;
  private final List<Dependency> dependencies;
  private Map<String, String> sessionProperties;

  public DeclarationSessionCreationRequest(List<Dependency> dependencies,
                                           ArtifactDeclaration artifactDeclaration,
                                           Map<String, String> sessionProperties) {
    this.artifactDeclaration = artifactDeclaration;
    this.dependencies = dependencies;
    this.sessionProperties = sessionProperties;
  }

  public ArtifactDeclaration getArtifactDeclaration() {
    return artifactDeclaration;
  }

  public List<Dependency> getDependencies() {
    return dependencies;
  }

  public Map<String, String> getSessionProperties() {
    return sessionProperties;
  }
}
