/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.studoc.commons.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XMLPrettyFormatter {
    INSTANCE;

    private static final String TABULATION_TAG = "\t<";
    private static final String CDATA_TAG = "<(?!\\!\\[CDATA)";

    public String format(String unformattedXml) {
        String firstReplacement;
        StringWriter sw;
        SAXReader reader = new SAXReader();
        ByteArrayInputStream stream = new ByteArrayInputStream(unformattedXml.getBytes());
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setIndent(true);
            format.setIndent("\t");
            Document document = reader.read((InputStream)stream);
            sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
        }
        catch (Exception e) {
            sw = new StringWriter();
        }
        String formatedString = sw.toString();
        String result = firstReplacement = formatedString.replaceAll(CDATA_TAG, TABULATION_TAG);
        try {
            result = this.addTabulationToScriptingComponents(firstReplacement);
        }
        catch (IOException e) {
            throw new RuntimeException("Error pretty printing xml:\n" + unformattedXml, e);
        }
        return result;
    }

    private String addTabulationToScriptingComponents(String input) throws IOException {
        BufferedReader bufReader = new BufferedReader(new StringReader(input));
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufReader.readLine()) != null) {
            String trimedLine = line.trim();
            if (!trimedLine.startsWith("<")) {
                line = "\t" + trimedLine;
            }
            line = line + System.getProperty("line.separator");
            lines.add(line);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : lines) {
            builder.append(string);
        }
        return builder.toString();
    }
}

