/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.api.UpdatePolicy;

public final class UpdatePolicyUtils {
    private UpdatePolicyUtils() {
    }

    public static long toMinutes(UpdatePolicy updatePolicy) {
        if ("daily".equals(updatePolicy)) {
            return 1440L;
        }
        if ("always".equals(updatePolicy)) {
            return 0L;
        }
        if (updatePolicy != null && updatePolicy.getUpdatePolicy().startsWith("interval")) {
            return UpdatePolicyUtils.getMinutes(updatePolicy.getUpdatePolicy());
        }
        return Integer.MAX_VALUE;
    }

    private static int getMinutes(String policy) {
        int minutes;
        try {
            String s = policy.substring("interval".length() + 1);
            minutes = Integer.valueOf(s);
        }
        catch (RuntimeException e) {
            throw new ToolingException(String.format("Invalid update policy interval, pattern supported is: '%s', value was: '%s' where X is minutes", policy, "interval:X"));
        }
        return minutes;
    }
}

