/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import org.mule.tooling.client.bootstrap.api.ExecutorServiceConfiguration;
import org.mule.tooling.client.internal.util.Preconditions;

public class DefaultExecutorServiceConfigurationBuilder
implements ExecutorServiceConfiguration.ExecutorServiceConfigurationBuilder {
    private int maxNumberOfThreads;

    @Override
    public ExecutorServiceConfiguration.ExecutorServiceConfigurationBuilder maxNumberOfThreads(int maxNumberOfThreads) {
        Preconditions.checkState((maxNumberOfThreads > 0 ? 1 : 0) != 0, (String)"maxNumberOfThreads has to be greater than 0");
        this.maxNumberOfThreads = maxNumberOfThreads;
        return this;
    }

    @Override
    public ExecutorServiceConfiguration build() {
        return new DefaultExecutorServiceConfiguration(this.maxNumberOfThreads);
    }

    private static class DefaultExecutorServiceConfiguration
    implements ExecutorServiceConfiguration {
        private int maxNumberOfThreads;

        DefaultExecutorServiceConfiguration(int maxNumberOfThreads) {
            this.maxNumberOfThreads = maxNumberOfThreads;
        }

        @Override
        public int maxNumberOfThreads() {
            return this.maxNumberOfThreads;
        }
    }
}

