/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.artifact.resources.ResourceLoader;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

public class ResourceLoaderWrapper
implements ResourceLoader {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public ResourceLoaderWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public InputStream getResourceAsStream(String resource) {
        return (InputStream)this.dispatcher.dispatchRemoteMethod("getResourceAsStream", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)resource));
    }

    public URL getResource(String resource) {
        return (URL)this.dispatcher.dispatchRemoteMethod("getResource", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)resource));
    }

    public Optional<URL> findIn(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type) {
        return (Optional)this.dispatcher.dispatchRemoteMethod("findIn", (List<Class>)ImmutableList.of(String.class, String.class, String.class, Optional.class, String.class, String.class), (List<String>)ImmutableList.of((Object)resource, (Object)groupId, (Object)artifactId, (Object)this.serializer.serialize(version), (Object)classifier, (Object)type));
    }

    public Optional<InputStream> loadFrom(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type) {
        return (Optional)this.dispatcher.dispatchRemoteMethod("loadFrom", (List<Class>)ImmutableList.of(String.class, String.class, String.class, Optional.class, String.class, String.class), (List<String>)ImmutableList.of((Object)resource, (Object)groupId, (Object)artifactId, (Object)this.serializer.serialize(version), (Object)classifier, (Object)type));
    }
}

