/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingVersionResolverConfiguration;
import org.mule.tooling.client.bootstrap.api.UpdatePolicy;
import org.mule.tooling.client.internal.util.Preconditions;

public class DefaultToolingVersionResolverConfigurationBuilder
implements ToolingVersionResolverConfiguration.ToolingVersionResolverConfigurationBuilder {
    private MavenConfiguration mavenConfiguration;
    private UpdatePolicy updatePolicy;
    private LinkedHashMap<String, String> mappings = new LinkedHashMap();
    private List<String> allowedSuffixes = Collections.emptyList();

    @Override
    public ToolingVersionResolverConfiguration.ToolingVersionResolverConfigurationBuilder mavenConfiguration(MavenConfiguration mavenConfiguration) {
        Preconditions.checkNotNull((Object)mavenConfiguration, (String)"mavenConfiguration cannot be null");
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    public ToolingVersionResolverConfiguration.ToolingVersionResolverConfigurationBuilder mappings(LinkedHashMap mappings) {
        Preconditions.checkNotNull((Object)mappings, (String)"mappings cannot be null");
        this.mappings.clear();
        this.mappings.putAll(mappings);
        return this;
    }

    @Override
    public ToolingVersionResolverConfiguration.ToolingVersionResolverConfigurationBuilder updatePolicy(UpdatePolicy updatePolicy) {
        Preconditions.checkNotNull((Object)updatePolicy, (String)"updatePolicy cannot be null");
        this.updatePolicy = updatePolicy;
        return this;
    }

    @Override
    public ToolingVersionResolverConfiguration.ToolingVersionResolverConfigurationBuilder allowedSuffixes(String ... allowedSuffixes) {
        Preconditions.checkNotNull((Object)allowedSuffixes, (String)"allowedSuffixes cannot be null");
        this.allowedSuffixes = Arrays.asList(allowedSuffixes);
        return this;
    }

    @Override
    public ToolingVersionResolverConfiguration build() {
        return new DefaultToolingRuntimeClientBootstrapConfiguration(this.mavenConfiguration, this.updatePolicy, this.mappings, this.allowedSuffixes);
    }

    private static class DefaultToolingRuntimeClientBootstrapConfiguration
    implements ToolingVersionResolverConfiguration {
        private MavenConfiguration mavenConfiguration;
        private UpdatePolicy updatePolicy;
        private LinkedHashMap<String, String> mappings = new LinkedHashMap();
        private List<String> allowedSuffixes;

        DefaultToolingRuntimeClientBootstrapConfiguration(MavenConfiguration mavenConfiguration, UpdatePolicy updatePolicy, LinkedHashMap<String, String> mappings, List<String> allowedSuffixes) {
            Preconditions.checkNotNull((Object)mavenConfiguration, (String)"mavenConfiguration cannot be null");
            this.mavenConfiguration = mavenConfiguration;
            this.updatePolicy = updatePolicy == null ? new UpdatePolicy("daily") : updatePolicy;
            this.mappings.putAll(mappings);
            this.allowedSuffixes = allowedSuffixes;
        }

        @Override
        public MavenConfiguration mavenConfiguration() {
            return this.mavenConfiguration;
        }

        @Override
        public UpdatePolicy remoteVersionUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public LinkedHashMap<String, String> mappings() {
            return this.mappings;
        }

        @Override
        public List<String> allowedSuffixes() {
            return this.allowedSuffixes;
        }
    }
}

