/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.descriptors.dependency;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.tooling.client.api.descriptors.dependency.Exclusion;

public class Dependency
implements Serializable,
Cloneable {
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "jar";
    private String classifier;
    private String scope;
    private String systemPath;
    private List<Exclusion> exclusions;
    private String optional;
    private String managementKey;

    public void addExclusion(Exclusion exclusion) {
        this.getExclusions().add(exclusion);
    }

    public Dependency clone() {
        try {
            Dependency copy = (Dependency)super.clone();
            if (this.exclusions != null) {
                copy.exclusions = new ArrayList<Exclusion>();
                for (Exclusion item : this.exclusions) {
                    copy.exclusions.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception e) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(e);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public List<Exclusion> getExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<Exclusion>();
        }
        return this.exclusions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOptional() {
        return this.optional;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeExclusion(Exclusion exclusion) {
        this.getExclusions().remove(exclusion);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setExclusions(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setOptional(String optional) {
        this.optional = optional;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isOptional() {
        return this.optional != null ? Boolean.parseBoolean(this.optional) : false;
    }

    public void setOptional(boolean optional) {
        this.optional = String.valueOf(optional);
    }

    public String getManagementKey() {
        if (this.managementKey == null) {
            this.managementKey = this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier != null ? ":" + this.classifier : "");
        }
        return this.managementKey;
    }

    public String toString() {
        return "Dependency {groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(that.groupId, this.groupId) && Objects.equals(that.artifactId, this.artifactId) && Objects.equals(that.version, this.version) && Objects.equals(that.type, this.type) && Objects.equals(that.classifier, this.classifier) && Objects.equals(that.scope, this.scope) && Objects.equals(that.systemPath, this.systemPath) && Objects.equals(that.exclusions, this.exclusions) && Objects.equals(that.optional, this.optional) && Objects.equals(that.managementKey, this.managementKey);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.systemPath != null ? this.systemPath.hashCode() : 0);
        result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
        result = 31 * result + (this.optional != null ? this.optional.hashCode() : 0);
        result = 31 * result + (this.managementKey != null ? this.managementKey.hashCode() : 0);
        return result;
    }
}

