/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.component.location;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.component.TypedComponentIdentifier;
import org.mule.tooling.client.api.component.location.LocationPart;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;

public class ComponentLocation {
    private String location;
    private String fileName;
    private Integer lineInFile;
    private SourceCodeLocation sourceCodeLocation;
    private TypedComponentIdentifier typedComponentIdentifier;
    private List<LocationPart> locationParts;

    private ComponentLocation() {
    }

    public ComponentLocation(String location, TypedComponentIdentifier typedComponentIdentifier, List<LocationPart> locationParts, Optional<SourceCodeLocation> sourceCodeLocation) {
        this.location = location;
        this.sourceCodeLocation = sourceCodeLocation.orElse(null);
        this.typedComponentIdentifier = typedComponentIdentifier;
        this.locationParts = locationParts;
    }

    public String getLocation() {
        return this.location;
    }

    public Optional<String> getFileName() {
        if (this.fileName != null) {
            return Optional.of(this.fileName);
        }
        return this.getSourceCodeLocation().map(sourceCodeLocation -> sourceCodeLocation.getFileName());
    }

    public Optional<Integer> getLineInFile() {
        if (this.lineInFile != null) {
            return Optional.of(this.lineInFile);
        }
        return this.getSourceCodeLocation().map(sourceCodeLocation -> sourceCodeLocation.getStartLine());
    }

    public Optional<SourceCodeLocation> getSourceCodeLocation() {
        return Optional.ofNullable(this.sourceCodeLocation);
    }

    public List<LocationPart> getParts() {
        return this.locationParts;
    }

    public TypedComponentIdentifier getComponentIdentifier() {
        return this.typedComponentIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentLocation that = (ComponentLocation)o;
        return Objects.equals(this.getLocation(), that.getLocation()) && Objects.equals(this.getSourceCodeLocation(), that.getSourceCodeLocation()) && Objects.equals(this.typedComponentIdentifier, that.typedComponentIdentifier) && Objects.equals(this.locationParts, that.locationParts);
    }

    public int hashCode() {
        return Objects.hash(this.getLocation(), this.getSourceCodeLocation(), this.typedComponentIdentifier, this.locationParts);
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.location + " @ " + this.sourceCodeLocation.toString() + "}";
    }
}

