/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.ssl;

import java.io.File;
import java.util.Objects;
import org.mule.tooling.client.internal.configuration.ssl.ImmutableKeyStoreConfig;

public interface KeyStoreConfig {
    public File getKeyStoreFile();

    public String getKeyStorePassword();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File keyStoreFile;
        private String keyStorePassword;

        public Builder withKeyStoreFile(File keyStoreFile) {
            Objects.requireNonNull(keyStoreFile, "keyStoreFile cannot be null");
            this.keyStoreFile = keyStoreFile;
            return this;
        }

        public Builder withKeyStorePassword(String keyStorePassword) {
            Objects.requireNonNull(keyStorePassword, "keyStorePassword cannot be null");
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public KeyStoreConfig build() {
            return new ImmutableKeyStoreConfig(this.keyStoreFile, this.keyStorePassword);
        }
    }
}

