/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import org.mule.tooling.client.internal.serialization.ClassSerializerFilter;

public class ClassLoaderClassSerializerFilter
implements ClassSerializerFilter {
    private ClassLoader targetClassLoader;
    private Cache<Class, Boolean> classesCache;

    public ClassLoaderClassSerializerFilter(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
        this.classesCache = CacheBuilder.newBuilder().build();
    }

    @Override
    public boolean shouldInclude(Class type) {
        try {
            return (Boolean)this.classesCache.get((Object)type, () -> {
                try {
                    this.targetClassLoader.loadClass(type.getName());
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
                return true;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

