/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.nested;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModelVisitor;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.feature.Feature;

public class NestedComponentModel
implements NestableElementModel {
    private boolean isRequired;
    private String name;
    private String description;
    private DisplayModel displayModel;
    private Set<StereotypeModel> allowedStereotypes;
    private Feature<List<ParameterGroupModel>> parameterGroupModels;
    private Feature<DeprecationModel> deprecationModel;
    private Feature<Set<ErrorModel>> errorModels;
    private Feature<Integer> minOccurs;
    private Feature<Optional<Integer>> maxOccurs;
    private Feature<List<? extends NestableElementModel>> nestedComponents;
    private Feature<StereotypeModel> stereotypeModel;
    private Set<String> semanticTerms;

    public NestedComponentModel() {
    }

    @Deprecated
    public NestedComponentModel(String name, String description, DisplayModel displayModel, boolean isRequired, Set<StereotypeModel> allowedStereotypes) {
        this(name, description, displayModel, isRequired, allowedStereotypes, null, null, null, null, null, null, null, Collections.emptySet());
    }

    public NestedComponentModel(String name, String description, DisplayModel displayModel, boolean isRequired, Set<StereotypeModel> allowedStereotypes, List<ParameterGroupModel> parameterGroupModels, DeprecationModel deprecationModel, Set<ErrorModel> errorModels, Integer minOccurs, Integer maxOccurs, List<? extends NestableElementModel> nestedComponents, StereotypeModel stereotypeModel, Set<String> semanticTerms) {
        this.isRequired = isRequired;
        this.allowedStereotypes = allowedStereotypes;
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.parameterGroupModels = Feature.enabled(parameterGroupModels);
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.errorModels = Feature.enabled(errorModels);
        this.minOccurs = Feature.enabled(minOccurs);
        this.maxOccurs = Feature.enabled(Optional.ofNullable(maxOccurs));
        this.nestedComponents = Feature.enabled(nestedComponents);
        this.stereotypeModel = Feature.enabled(stereotypeModel);
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    public Set<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public Feature<List<ParameterGroupModel>> getParameterGroupModels() {
        if (this.parameterGroupModels == null) {
            return Feature.disabled();
        }
        return this.parameterGroupModels;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            return Feature.disabled();
        }
        return this.deprecationModel;
    }

    public Feature<Set<ErrorModel>> getErrorModels() {
        if (this.errorModels == null) {
            return Feature.disabled();
        }
        return this.errorModels;
    }

    public Feature<Integer> getMinOccurs() {
        if (this.minOccurs == null) {
            return Feature.disabled();
        }
        return this.minOccurs;
    }

    public Feature<Optional<Integer>> getMaxOccurs() {
        if (this.maxOccurs == null) {
            return Feature.disabled();
        }
        return this.maxOccurs;
    }

    public Feature<List<? extends NestableElementModel>> getNestedComponents() {
        if (this.nestedComponents == null) {
            return Feature.disabled();
        }
        return this.nestedComponents;
    }

    public Feature<StereotypeModel> getStereotype() {
        if (this.stereotypeModel == null) {
            return Feature.disabled();
        }
        return this.stereotypeModel;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    @Override
    public void accept(NestableElementModelVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((NestedComponentModel)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

