/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.mule.tooling.client.internal.serialization.FieldSerializerFilter;

public class ClassLoaderFieldSerializerFilter
implements FieldSerializerFilter {
    private ClassLoader targetClassLoader;
    private Cache<String, List<String>> fieldsByTypeCache;

    public ClassLoaderFieldSerializerFilter(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
        this.fieldsByTypeCache = CacheBuilder.newBuilder().build();
    }

    @Override
    public boolean shouldInclude(Class type, Field field) throws ClassNotFoundException {
        try {
            return ((List)this.fieldsByTypeCache.get((Object)type.getName(), () -> {
                ArrayList<String> allFields = new ArrayList<String>();
                for (Class<?> nextClass = this.targetClassLoader.loadClass(type.getName()); nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                    Field[] declaredFields = nextClass.getDeclaredFields();
                    if (declaredFields == null) continue;
                    for (Field f : declaredFields) {
                        if (Modifier.isStatic(f.getModifiers())) continue;
                        allFields.add(f.getName());
                    }
                }
                return allFields;
            })).contains(field.getName());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }
}

