/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.declaration.type.annotation;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.internal.util.Preconditions;

public abstract class PrefixDefinedAnnotation {
    private static final String DELIMITER = ":";
    private String prefix = "";
    private String element = "";

    public PrefixDefinedAnnotation() {
    }

    public PrefixDefinedAnnotation(String prefix, String content) {
        this.setValues(prefix, content);
    }

    void setValues(String prefix, String content) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)prefix) && !StringUtils.isBlank((CharSequence)content), String.format("prefix and content should both be specified, got prefix: %s and content: %s", prefix, content));
        this.prefix = prefix;
        this.element = content;
    }

    public boolean isDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.prefix) && StringUtils.isNotEmpty((CharSequence)this.element);
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getContent() {
        return this.element;
    }

    public String getFormattedAnnotation() {
        return this.prefix + DELIMITER + this.element;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrefixDefinedAnnotation) {
            return this.prefix.equals(((PrefixDefinedAnnotation)obj).getPrefix()) && this.element.equals(((PrefixDefinedAnnotation)obj).getContent());
        }
        return false;
    }

    public int hashCode() {
        return this.prefix.hashCode() + this.element.hashCode();
    }
}

