/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.dataweave.validation;

import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

public class DataWeaveValidationRequest
extends AbstractToolingRequest {
    private String script;
    private Map<String, MetadataType> globalBindings;
    private Map<String, MetadataType> functionBindings;
    private MetadataType eventType;

    private DataWeaveValidationRequest(String script, Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings, MetadataType eventType) {
        this.script = script;
        this.globalBindings = globalBindings;
        this.functionBindings = functionBindings;
        this.eventType = eventType;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }

    public MetadataType getEventType() {
        return this.eventType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, MetadataType> globalBindings;
        private Map<String, MetadataType> functionBindings;
        private MetadataType eventType;
        private String script;

        private Builder() {
        }

        public Builder withGlobalBindings(Map<String, MetadataType> globalBindings) {
            this.globalBindings = globalBindings;
            return this;
        }

        public Builder withFunctionBindings(Map<String, MetadataType> functionBindings) {
            this.functionBindings = functionBindings;
            return this;
        }

        public Builder withEventType(MetadataType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public DataWeaveValidationRequest build() {
            return new DataWeaveValidationRequest(this.script, this.globalBindings, this.functionBindings, this.eventType);
        }
    }
}

