/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model;

import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.internal.util.Preconditions;

public class SubTypesModel {
    private ObjectType baseType;
    private Set<ObjectType> subTypes;

    private SubTypesModel() {
    }

    public SubTypesModel(ObjectType baseType, Set<ObjectType> subTypes) {
        Preconditions.checkArgument(baseType != null, "baseType cannot be null");
        Preconditions.checkArgument(baseType instanceof ObjectType, "Only ObjectTypes can be extended");
        Preconditions.checkArgument(subTypes != null && !subTypes.isEmpty(), "subTypes cannot be null nor empty");
        Preconditions.checkArgument(subTypes.stream().allMatch(s -> s instanceof ObjectType), "subTypes of an ObjectType can only be instances of ObjectType");
        this.baseType = baseType;
        this.subTypes = subTypes;
    }

    public ObjectType getBaseType() {
        return this.baseType;
    }

    public Set<ObjectType> getSubTypes() {
        return this.subTypes;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

