/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.mule.tooling.client.internal.serialization.ClassSerializerFilter;
import org.mule.tooling.client.internal.serialization.ExternalizableKryo;

public class ExtendedCompatibleFieldSerializer<T>
extends CompatibleFieldSerializer<T> {
    public ExtendedCompatibleFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    protected void initializeCachedFields() {
        ExternalizableKryo kryo = (ExternalizableKryo)this.getKryo();
        FieldSerializer.CachedField[] fields = this.getFields();
        try {
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                Field field = fields[i].getField();
                if (kryo.getFieldSerializerFilter().shouldInclude(this.getType(), field)) continue;
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)("Ignoring field: " + fields[i] + " as it is not present in target class loader"));
                }
                this.removedFields.add(fields[i]);
            }
        }
        catch (ClassNotFoundException e) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)"Ignoring all fields as class it nos present in target class loader");
            }
            this.removedFields.addAll(Arrays.asList(fields));
        }
    }

    public void write(Kryo kryo, Output output, T object) {
        ClassSerializerFilter classSerializerFilter = this.getClassSerializerFilter();
        if (classSerializerFilter.shouldInclude(this.getType())) {
            super.write(kryo, output, object);
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> type) {
        try {
            return (T)super.create(kryo, input, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ClassSerializerFilter getClassSerializerFilter() {
        ExternalizableKryo externalizableKryo = (ExternalizableKryo)this.getKryo();
        return externalizableKryo.getClassSerializerFilter();
    }
}

