/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.types;

import org.junit.Test;
import org.mule.tooling.client.api.types.UnknownType;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

public class UnkownTypeTestCase {

  @Test
  public void allPropertiesFalseMustBeUnkown() {
    TestType type = new TestType(false, false);
    assertThat(type.isUnknown(), is(true));
  }

  @Test
  public void onePropertyTrueMustNotBeUnkown() {
    TestType type = new TestType(true, false);
    assertThat(type.isUnknown(), is(false));
  }

  public class TestType extends UnknownType {

    private boolean prop1, prop2;

    public TestType(boolean p1, boolean p2) {
      prop1 = p1;
      prop2 = p2;
    }

    public boolean isProp1() {
      return prop1;
    }

    public boolean isProp2() {
      return prop2;
    }
  }

}
