/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.features;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.tooling.client.api.exception.FeatureNotSupportedException;
import org.mule.tooling.client.api.feature.Feature;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.mule.tooling.client.api.feature.Feature.disabled;
import static org.mule.tooling.client.api.feature.Feature.enabled;

public class FeaturesTestCase {

  private static final String TEST_VALUE = "R2D2";

  private FeaturedClass featuredClass = new FeaturedClass();

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Test
  public void testDisabled() {
    expectedException.expect(instanceOf(FeatureNotSupportedException.class));
    featuredClass.getValue();
  }

  @Test
  public void testEnabled() {
    featuredClass.setValue(TEST_VALUE);
    assertThat(featuredClass.getValue(), is(TEST_VALUE));
  }


  private class FeaturedClass {

    Feature<String> value = disabled();

    public void setValue(String value) {
      this.value = enabled(value);
    }

    public String getValue() {
      return value.get();
    }
  }
}
