/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import org.mule.tooling.client.api.extension.model.value.ValuesResolverModel;

import org.junit.Test;

public class ValuesResolverModelTestCase {

  @Test
  public void metadataKeyResolverName() {
    String category = "someCategory";
    String resolverName = "someResolverName";
    assertThat(ValuesResolverModel.metadataKeyResolverName(category, resolverName),
               is("metadataKey(category::someCategory,name::someResolverName)"));
  }

  @Test
  public void valueProviderResolverName() {
    String providerId = "someProviderId";
    assertThat(ValuesResolverModel.valueProviderResolverName(providerId), is("valueProvider(id::someProviderId)"));
  }

}
