/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.serialization;

/**
 * Filter to select which classes should be included in the serialization when writing and reading data.
 *
 * @since 1.2
 */
public interface ClassSerializerFilter {

  /**
   * @param type the {@link Class} type if it could be deserialized in the target class loader.
   * @return {@code true} if it should be serialized or not.
   */
  boolean shouldInclude(Class type);

}
