/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.persistence;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

/**
 * {@link TypeAdapterFactory} for {@link MetadataType}.
 *
 * @since 1.0
 */
public class MetadataTypeAdapterFactory implements TypeAdapterFactory {

  private ObjectTypeReferenceHandler referenceHandler;

  public MetadataTypeAdapterFactory() {
    this.referenceHandler = new NullObjectTypeReferenceHandler();
  }

  public MetadataTypeAdapterFactory(ObjectTypeReferenceHandler referenceHandler) {
    this.referenceHandler = referenceHandler;
  }

  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (MetadataType.class.isAssignableFrom(type.getRawType())) {
      MetadataTypeGsonTypeAdapterWithNullSupport metadataTypeGsonTypeAdapterWithNullSupport =
          new MetadataTypeGsonTypeAdapterWithNullSupport(new MetadataTypeGsonTypeAdapter(referenceHandler));
      return (TypeAdapter<T>) metadataTypeGsonTypeAdapterWithNullSupport;
    }
    return null;
  }
}
