/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;
import org.mule.tooling.client.internal.cache.CacheStorageMapWrapperFactory;

import java.util.Map;

/**
 * Factory for a {@link Map} that wraps a {@link MetadataCacheStorage}
 * <p>
 * This should be used internally to avoid serialization between class loaders. Since the storage is wrapped by a Map, it will be
 * loaded by all class loaders and methods can be called freely without requiring reflection.
 *
 * @since 1.2.2, 1.3.0
 * @deprecated use {@link CacheStorageMapWrapperFactory}
 */
@Deprecated
public interface MetadataCacheStorageMapWrapperFactory extends CacheStorageMapWrapperFactory {

}
