/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.types;

import org.mule.tooling.client.api.message.history.MessageHistory;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.component.location.ComponentLocation;

/**
 * Entry for {@link Transaction} from {@link MessageHistory}. Represents the {@link EventModel} at the specified
 * {@link ComponentLocation}.
 *
 * @since 1.0
 */
public class TransactionStackEntry {

  private EventModel input;
  private EventModel data;
  private ComponentLocation componentLocation;
  private long timestamp;

  public void setInput(EventModel input) {
    this.input = input;
  }

  public void setEventModel(EventModel data) {
    this.data = data;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }

  public EventModel getInput() {
    return input;
  }

  public EventModel getData() {
    return data;
  }

  public ComponentLocation getComponentLocation() {
    return componentLocation;
  }

  public void setComponentLocation(ComponentLocation componentLocation) {
    this.componentLocation = componentLocation;
  }
}
