/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.sampledata.request;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;

import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

/**
 * Request entity for retrieving {@link org.mule.tooling.client.api.sampledata.ComponentSampleDataResult} for a
 * {@link ToolingArtifact}.
 *
 * @since 1.4
 */
public class SampleDataRequest extends AbstractToolingRequest {

  private String location;

  /**
   * Sets the location path of the component with a SampleData resolver inside the flow.
   *
   * @param location the location path of the SampleData resolver component inside the flow.
   */
  public void setLocation(String location) {
    requireNonNull(location, "componentPath cannot null");
    this.location = location;
  }

  /**
   * @return the location path of the SampleData resolver component inside the flow.
   */
  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return format("%s{requestTimeout=%s,componentLocation=%s}", getShortClassName(this.getClass()), getRequestTimeout(),
                  location);
  }

}
