/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.message.history;

/**
 * Immutable implementation for {@link TypedValue}.
 *
 * @since 1.0
 */
public class ImmutableTypedValue implements TypedValue {

  private DataType dataType;
  private byte[] content;

  private ImmutableTypedValue() {}

  /**
   * Creates a builder for the {@link ImmutableTypedValue} object.
   *
   * @return a new builder.
   */
  public static Builder builder() {
    return new Builder();
  }

  @Override
  public DataType getDataType() {
    return this.dataType;
  }

  @Override
  public byte[] getContent() {
    return this.content;
  }

  /**
   * Builder for creating {@link ImmutableTypedValue} objects.
   */
  public static class Builder {

    private ImmutableTypedValue instance;

    private Builder() {
      instance = new ImmutableTypedValue();
    }

    public Builder dataType(DataType dataType) {
      instance.dataType = dataType;
      return this;
    }

    public Builder content(byte[] content) {
      instance.content = content;
      return this;
    }

    public ImmutableTypedValue build() {
      return instance;
    }
  }

}
