/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.icons;

import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;

/**
 * Service to retrieve the icons that are packaged inside an Extension.
 *
 * @since 1.1.0
 */
public interface ExtensionIconsService {

  /**
   * Given a {@link ArtifactDescriptor} which describes the GAV for an Extension, retrieves the given artifacts a
   * 
   * @param artifactDescriptor descriptor for an artifact represented in Maven coordinates.
   * @return An {@link IconsResult} providing the found icons
   */
  IconsResult getIconsFor(ArtifactDescriptor artifactDescriptor);
}
