/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.semantic;

import static java.util.Collections.emptySet;

import org.mule.tooling.client.api.feature.Feature;

import java.util.Collections;
import java.util.Set;

/**
 * Interface to be implemented by any model that allows having Semantic terms.
 *
 * @since 1.4.0
 */
public interface HasSemanticTerms {

  /**
   * Returns the semantic terms contained in this model.
   *
   * This could have been a {@link Feature} but instead, implementations should handle the cases where coming from an older
   * version by returning an {@link Collections#emptySet()}
   */
  default Set<String> getSemanticTerms() {
    return emptySet();
  }

}
