/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.property;

import javax.xml.namespace.QName;

/**
 * Indicates that the parameter model relates to a {@link QName} which is not the one the extension belongs to.
 *
 * @since 1.0
 */
public class QNameModel {

  private QName value;

  // Just needed in order to serialize this object
  private QNameModel() {}

  public QNameModel(QName value) {
    this.value = value;
  }

  public QName getValue() {
    return this.value;
  }

}
