/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.deprecated;

import static java.util.Optional.ofNullable;

import java.util.Optional;

/**
 * A definition of a deprecated part of an extension.
 *
 * @since 1.2
 */

public class DeprecationModel {

  private String message;
  private String deprecatedSince;
  private String toRemoveIn;


  public DeprecationModel() {}

  public DeprecationModel(String message, String deprecatedSince, String toRemoveIn) {
    this.message = message;
    this.deprecatedSince = deprecatedSince;
    this.toRemoveIn = toRemoveIn;
  }

  public String getMessage() {
    return message;
  }

  public String getDeprecatedSince() {
    return deprecatedSince;
  }

  public Optional<String> getToRemoveIn() {
    return ofNullable(toRemoveIn);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    DeprecationModel that = (DeprecationModel) o;

    if (!message.equals(that.message)) {
      return false;
    }
    if (!deprecatedSince.equals(that.deprecatedSince)) {
      return false;
    }
    return toRemoveIn != null ? toRemoveIn.equals(that.toRemoveIn) : that.toRemoveIn == null;
  }

  @Override
  public int hashCode() {
    int result = message.hashCode();
    result = 31 * result + deprecatedSince.hashCode();
    result = 31 * result + (toRemoveIn != null ? toRemoveIn.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "DeprecationModel{" +
        "message='" + message + '\'' +
        ", deprecatedSince='" + deprecatedSince + '\'' +
        (toRemoveIn != null ? ", toRemoveIn='" + toRemoveIn + '\'' : "") +
        '}';
  }
}
